/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.deathchest;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.smileycorp.deathchest.ConfigHandler;

@Mod.EventBusSubscriber
public class EventListener {
    @SubscribeEvent
    public static void onDeathEvent(LivingDropsEvent event) {
        Level level = event.getEntity().f_19853_;
        if (event.getEntity() instanceof Player & !level.f_46443_) {
            Player player = (Player)event.getEntity();
            ArrayList<NonNullList> items = new ArrayList<NonNullList>();
            for (ItemEntity item : event.getDrops()) {
                if (items.isEmpty()) {
                    items.add(NonNullList.m_122779_());
                }
                if (((NonNullList)items.get(items.size() - 1)).size() >= 27) {
                    items.add(NonNullList.m_122779_());
                }
                ((NonNullList)items.get(items.size() - 1)).add((Object)item.m_32055_());
            }
            if (items.size() > 0) {
                BlockPos pos = new BlockPos(player.m_20182_());
                for (int i = pos.m_123342_(); i < level.m_151558_() - items.size(); ++i) {
                    if (EventListener.canPlace(level, pos, items.size())) {
                        for (int j = 0; j < items.size(); ++j) {
                            EventListener.setChest(level, pos.m_6630_(j), player, (NonNullList<ItemStack>)((NonNullList)items.get(j)));
                        }
                        if (((Boolean)ConfigHandler.hasSkull.get()).booleanValue() && level.m_46859_(pos.m_6630_(items.size()))) {
                            level.m_46597_(pos.m_6630_(items.size()), Blocks.f_50316_.m_49966_());
                            SkullBlockEntity skull = new SkullBlockEntity(pos.m_6630_(items.size()), Blocks.f_50316_.m_49966_());
                            skull.m_59769_(player.m_36316_());
                            level.m_151523_((BlockEntity)skull);
                        }
                        event.setCanceled(true);
                        return;
                    }
                    pos = pos.m_7494_();
                }
            }
        }
    }

    private static boolean canPlace(Level level, BlockPos pos, int size) {
        for (int i = 0; i < size; ++i) {
            Block block = level.m_8055_(pos.m_6630_(i)).m_60734_();
            if (level.m_46859_(pos) || block instanceof BushBlock || block instanceof LiquidBlock || block instanceof BaseFireBlock) continue;
            return false;
        }
        return true;
    }

    private static void setChest(Level level, BlockPos pos, Player player, NonNullList<ItemStack> items) {
        if (level.m_8055_(pos).m_60734_() == Blocks.f_49990_) {
            level.m_46597_(pos, (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51480_, (Comparable)Boolean.valueOf(true)));
        } else {
            level.m_46597_(pos, Blocks.f_50087_.m_49966_());
        }
        ChestBlockEntity te = new ChestBlockEntity(pos, Blocks.f_50087_.m_49966_());
        if (((Boolean)ConfigHandler.lockChest.get()).booleanValue()) {
            CompoundTag nbt = te.m_187482_();
            nbt.m_128359_("Lock", player.m_20149_());
            te.m_142466_(nbt);
            te.m_6596_();
        }
        te.m_58638_((Component)MutableComponent.m_237204_((ComponentContents)new TranslatableContents(player.m_5446_().getString() + "'s Loot")));
        for (int slot = 0; slot < items.size(); ++slot) {
            te.m_6836_(slot, (ItemStack)items.get(slot));
        }
        level.m_151523_((BlockEntity)te);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRespawnEvent(PlayerEvent.Clone event) {
        Player player = event.getOriginal();
        if (!player.f_19853_.f_46443_ && player != null && event.isWasDeath() && ((Boolean)ConfigHandler.giveJournal.get()).booleanValue()) {
            BlockPos pos = player.m_20183_();
            long time = player.f_19853_.m_46467_();
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("generation", 3);
            nbt.m_128359_("title", "Death Journal");
            nbt.m_128359_("author", player.m_5446_().getString());
            StringBuilder contents = new StringBuilder("{\"text\":\"Death Time: " + time);
            contents.append("\\n\\nDimension: " + player.f_19853_.m_46472_().m_135782_() + "\\n");
            if (((Boolean)ConfigHandler.journalPos.get()).booleanValue()) {
                contents.append("\\nPosition: " + pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_());
            }
            contents.append("\\n\\nLocked: " + ConfigHandler.lockChest.get());
            contents.append("\"}");
            ListTag list = new ListTag();
            list.add((Object)StringTag.m_129297_((String)contents.toString()));
            nbt.m_128365_("pages", (Tag)list);
            ItemStack stack = new ItemStack((ItemLike)Items.f_42615_);
            if (((Boolean)ConfigHandler.lockChest.get()).booleanValue()) {
                nbt.m_128359_("Key", player.m_20149_());
            }
            stack.m_41751_(nbt);
            if (!event.getEntity().m_150109_().m_36054_(stack)) {
                event.getEntity().m_36176_(stack, true);
            }
            event.getEntity().f_36096_.m_150429_();
            event.getEntity().m_150109_().m_6596_();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void interactBlockEvent(PlayerInteractEvent.RightClickBlock event) {
        ChestBlockEntity te;
        CompoundTag nbt;
        String lock;
        BlockPos pos;
        Player player = event.getEntity();
        Level level = player.f_19853_;
        if (!level.f_46443_ && level.m_7702_(pos = event.getPos()) instanceof ChestBlockEntity && (lock = (nbt = (te = (ChestBlockEntity)level.m_7702_(pos)).m_187482_()).m_128461_("Lock")) != null) {
            String key;
            CompoundTag stackNBT;
            int gen;
            if (player.m_20149_().equals(lock)) {
                nbt.m_128473_("Lock");
                te.m_142466_(nbt);
                te.m_6596_();
                player.m_5661_((Component)MutableComponent.m_237204_((ComponentContents)new TranslatableContents("Chest has been unlocked.")), true);
                return;
            }
            ItemStack stack = player.m_21120_(event.getHand());
            if (stack.m_41720_() == Items.f_42615_ && (gen = (stackNBT = stack.m_41783_()).m_128451_("generation")) == 3 && (key = stackNBT.m_128461_("Key")) != null && key.equals(lock)) {
                nbt.m_128473_("Lock");
                te.m_142466_(nbt);
                te.m_6596_();
                player.m_5661_((Component)MutableComponent.m_237204_((ComponentContents)new TranslatableContents("Chest has been unlocked.")), true);
                return;
            }
        }
    }
}

