/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.hamsters.client.renderer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.starfish_studios.hamsters.client.model.HamsterModel;
import com.starfish_studios.hamsters.entity.Hamster;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoEntityRenderer;

public class HamsterRenderer
extends GeoEntityRenderer<Hamster> {
    private static final Map<Hamster.Variant, ResourceLocation> TEXTURES = (Map)Util.m_137469_((Object)Maps.newHashMap(), hashMap -> {
        hashMap.put(Hamster.Variant.WHITE, new ResourceLocation("hamsters", "textures/entity/hamster/white.png"));
        hashMap.put(Hamster.Variant.PEACHES_AND_CREAM, new ResourceLocation("hamsters", "textures/entity/hamster/peaches_and_cream.png"));
        hashMap.put(Hamster.Variant.ORANGE, new ResourceLocation("hamsters", "textures/entity/hamster/orange.png"));
        hashMap.put(Hamster.Variant.GREY_WHITE, new ResourceLocation("hamsters", "textures/entity/hamster/grey_white.png"));
        hashMap.put(Hamster.Variant.BROWN, new ResourceLocation("hamsters", "textures/entity/hamster/brown.png"));
        hashMap.put(Hamster.Variant.BLACK_WHITE, new ResourceLocation("hamsters", "textures/entity/hamster/black_white.png"));
        hashMap.put(Hamster.Variant.BLACK, new ResourceLocation("hamsters", "textures/entity/hamster/black.png"));
    });

    public HamsterRenderer(EntityRendererProvider.Context context) {
        super(context, (AnimatedGeoModel)new HamsterModel());
        this.f_114477_ = 0.3f;
    }

    @NotNull
    public ResourceLocation getTextureLocation(Hamster entity) {
        return TEXTURES.get((Object)entity.getVariant());
    }

    public void render(Hamster animatable, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (animatable.m_6162_()) {
            poseStack.m_85841_(0.6f, 0.6f, 0.6f);
        } else {
            poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        }
        super.render((LivingEntity)animatable, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public RenderType getRenderType(Hamster animatable, float partialTicks, PoseStack stack, @Nullable MultiBufferSource renderTypeBuffer, @Nullable VertexConsumer vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.m_110458_((ResourceLocation)textureLocation);
    }
}

