/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.bridges;

import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.data.BlockId;
import fr.samlegamer.addonslib.data.CreateBlockReferences;
import fr.samlegamer.addonslib.data.McwBlocksIdBase;
import java.util.List;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;

public class Bridges {
    public static final String modid = "mcwbridges";
    public static final String desc = "mcwbridges.bridges.desc";

    public static void setRegistrationWood(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item, CreativeModeTab tab) {
        Bridges.setRegistrationWoodModLoaded(set, block, item, tab, "minecraft", BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(0.5f, 2.5f).m_60918_(SoundType.f_56736_));
    }

    public static void setRegistrationRock(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item, CreativeModeTab tab) {
        Bridges.setRegistrationRockModLoaded(set, block, item, tab, "minecraft", BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(3.0f, 5.0f).m_60918_(SoundType.f_56742_));
    }

    public static void setRegistrationRockModLoaded(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item, CreativeModeTab tab, String modLoaded, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties STONE = prop;
        ModList modList = ModList.get();
        boolean isModMcwLoaded = modList.isLoaded(modid);
        boolean isModBaseLoaded = modList.isLoaded(modLoaded);
        for (String i : set) {
            for (BlockId blockId : McwBlocksIdBase.BRIDGES_STONE_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (isModMcwLoaded) {
                    CreateBlockReferences.createBlockStone(id, () -> Registration.getBlocksField(blockId.reflectedLocation(), STONE), block, item, tab, true, isModBaseLoaded);
                    continue;
                }
                CreateBlockReferences.createBlockStone(id, () -> new Block(STONE), block, item, tab, false, isModBaseLoaded);
            }
        }
    }

    public static void setRegistrationWoodModLoaded(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item, CreativeModeTab tab, String modLoaded, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties WOOD = prop;
        ModList modList = ModList.get();
        boolean isModMcwLoaded = modList.isLoaded(modid);
        boolean isModBaseLoaded = modList.isLoaded(modLoaded);
        for (String i : set) {
            for (BlockId blockId : McwBlocksIdBase.BRIDGES_WOOD_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (isModMcwLoaded) {
                    CreateBlockReferences.createBlock(id, () -> Registration.getBlocksField(blockId.reflectedLocation(), WOOD), block, item, tab, true, isModBaseLoaded);
                    continue;
                }
                CreateBlockReferences.createBlock(id, () -> new Block(WOOD), block, item, tab, false, isModBaseLoaded);
            }
        }
    }
}

