/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.fences;

import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.data.BlockId;
import fr.samlegamer.addonslib.data.CreateBlockReferences;
import fr.samlegamer.addonslib.data.McwBlocksIdBase;
import java.util.List;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;

public class Fences {
    public static final String modid = "mcwfences";

    public static void setRegistrationWood(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item, CreativeModeTab tab) {
        Fences.setRegistrationWoodModLoaded(set, block, item, tab, "minecraft", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_));
    }

    public static void setRegistrationHedges(List<String> leaves, DeferredRegister<Block> block, DeferredRegister<Item> item, CreativeModeTab tab) {
        Fences.setRegistrationHedgesModLoaded(leaves, block, item, tab, "minecraft", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_));
    }

    public static void setRegistrationRock(List<String> rock, DeferredRegister<Block> block, DeferredRegister<Item> item, CreativeModeTab tab) {
        Fences.setRegistrationRockModLoaded(rock, block, item, tab, "minecraft", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50064_));
    }

    public static void setRegistrationWoodModLoaded(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item, CreativeModeTab tab, String modLoaded, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties WOOD = prop;
        boolean isModMcwLoaded = ModList.get().isLoaded(modid);
        boolean isModBaseLoaded = ModList.get().isLoaded(modLoaded);
        for (String i : set) {
            for (BlockId blockId : McwBlocksIdBase.FENCES_WOOD_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (blockId.reflectedLocation().contains("FenceBlock")) {
                    CreateBlockReferences.createBlock(id, () -> new FenceBlock(WOOD), block, item, tab, isModMcwLoaded, isModBaseLoaded);
                    continue;
                }
                if (blockId.reflectedLocation().contains("FenceGateBlock")) {
                    CreateBlockReferences.createBlock(id, () -> new FenceGateBlock(WOOD), block, item, tab, isModMcwLoaded, isModBaseLoaded);
                    continue;
                }
                if (isModMcwLoaded) {
                    CreateBlockReferences.createBlock(id, () -> Registration.getBlocksField(blockId.reflectedLocation(), WOOD), block, item, tab, true, isModBaseLoaded);
                    continue;
                }
                CreateBlockReferences.createBlock(id, () -> new FenceBlock(WOOD), block, item, tab, false, isModBaseLoaded);
            }
        }
    }

    public static void setRegistrationHedgesModLoaded(List<String> leaves, DeferredRegister<Block> block, DeferredRegister<Item> item, CreativeModeTab tab, String modLoaded, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties HEDGES = prop;
        boolean isModMcwLoaded = ModList.get().isLoaded(modid);
        boolean isModBaseLoaded = ModList.get().isLoaded(modLoaded);
        for (String i : leaves) {
            for (BlockId blockId : McwBlocksIdBase.FENCES_LEAVE_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (isModMcwLoaded) {
                    CreateBlockReferences.createBlock(id, () -> Registration.getBlocksField(blockId.reflectedLocation(), HEDGES), block, item, tab, true, isModBaseLoaded);
                    continue;
                }
                CreateBlockReferences.createBlock(id, () -> new FenceBlock(HEDGES), block, item, tab, false, isModBaseLoaded);
            }
        }
    }

    public static void setRegistrationRockModLoaded(List<String> rock, DeferredRegister<Block> block, DeferredRegister<Item> item, CreativeModeTab tab, String modLoaded, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties STONE = prop;
        boolean isModMcwLoaded = ModList.get().isLoaded(modid);
        boolean isModBaseLoaded = ModList.get().isLoaded(modLoaded);
        for (String i : rock) {
            for (BlockId blockId : McwBlocksIdBase.FENCES_STONE_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (blockId.reflectedLocation().contains("FenceBlock")) {
                    CreateBlockReferences.createBlockStone(id, () -> new FenceBlock(STONE), block, item, tab, isModMcwLoaded, isModBaseLoaded);
                    continue;
                }
                if (blockId.reflectedLocation().contains("FenceGateBlock")) {
                    CreateBlockReferences.createBlockStone(id, () -> new FenceGateBlock(STONE), block, item, tab, isModMcwLoaded, isModBaseLoaded);
                    continue;
                }
                if (isModMcwLoaded) {
                    CreateBlockReferences.createBlockStone(id, () -> Registration.getBlocksField(blockId.reflectedLocation(), STONE), block, item, tab, true, isModBaseLoaded);
                    continue;
                }
                CreateBlockReferences.createBlockStone(id, () -> new FenceBlock(STONE), block, item, tab, false, isModBaseLoaded);
            }
        }
    }
}

