/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.roofs;

import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.data.BlockId;
import fr.samlegamer.addonslib.data.CreateBlockReferences;
import fr.samlegamer.addonslib.data.McwBlocksIdBase;
import java.util.List;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class Roofs {
    public static final String modid = "mcwroofs";

    public static void setRegistrationWood(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item, CreativeModeTab tab) {
        Roofs.setRegistrationWoodModLoaded(set, block, item, tab, "minecraft", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_));
    }

    public static void setRegistrationRock(List<String> rock, DeferredRegister<Block> block, DeferredRegister<Item> item, CreativeModeTab tab) {
        Roofs.setRegistrationRockModLoaded(rock, block, item, tab, "minecraft", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50064_));
    }

    public static void setRegistrationWoodModLoaded(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item, CreativeModeTab tab, String modLoaded, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties WOOD = prop;
        boolean isModMcwLoaded = ModList.get().isLoaded(modid);
        boolean isModBaseLoaded = ModList.get().isLoaded(modLoaded);
        for (String i : set) {
            for (BlockId blockId : McwBlocksIdBase.ROOFS_WOOD_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (blockId.reflectedLocation().contains("StairsBlock")) {
                    CreateBlockReferences.createBlock(id, () -> new StairBlock(() -> ((Block)Blocks.f_50705_).m_49966_(), WOOD), block, item, tab, isModMcwLoaded, isModBaseLoaded);
                    continue;
                }
                if (isModMcwLoaded) {
                    if (blockId.reflectedLocation().contains("Lower") || blockId.reflectedLocation().contains("Steep")) {
                        CreateBlockReferences.createBlock(id, () -> Registration.getBlocksField(blockId.reflectedLocation(), WOOD, Blocks.f_50705_.m_49966_()), block, item, tab, true, isModBaseLoaded);
                        continue;
                    }
                    CreateBlockReferences.createBlock(id, () -> Registration.getBlocksField(blockId.reflectedLocation(), WOOD), block, item, tab, true, isModBaseLoaded);
                    continue;
                }
                CreateBlockReferences.createBlock(id, () -> new Block(WOOD), block, item, tab, false, isModBaseLoaded);
            }
        }
    }

    public static void setRegistrationRockModLoaded(List<String> rock, DeferredRegister<Block> block, DeferredRegister<Item> item, CreativeModeTab tab, String modLoaded, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties STONE = prop;
        boolean isModMcwLoaded = ModList.get().isLoaded(modid);
        boolean isModBaseLoaded = ModList.get().isLoaded(modLoaded);
        for (String i : rock) {
            for (BlockId blockId : McwBlocksIdBase.ROOFS_STONE_BLOCKS.blocks()) {
                RegistryObject<Block> blockObj;
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (blockId.reflectedLocation().contains("StairsBlock")) {
                    blockObj = CreateBlockReferences.createBlockStone(id, () -> new StairBlock(() -> ((Block)Blocks.f_50652_).m_49966_(), STONE), block, item, tab, isModMcwLoaded, isModBaseLoaded);
                    continue;
                }
                if (isModMcwLoaded) {
                    if (blockId.reflectedLocation().contains("Lower") || blockId.reflectedLocation().contains("Steep")) {
                        blockObj = CreateBlockReferences.createBlockStone(id, () -> Registration.getBlocksField(blockId.reflectedLocation(), STONE, Blocks.f_50652_.m_49966_()), block, item, tab, true, isModBaseLoaded);
                        continue;
                    }
                    blockObj = CreateBlockReferences.createBlockStone(id, () -> Registration.getBlocksField(blockId.reflectedLocation(), STONE), block, item, tab, true, isModBaseLoaded);
                    continue;
                }
                RegistryObject<Block> registryObject = CreateBlockReferences.createBlockStone(id, () -> new Block(STONE), block, item, tab, false, isModBaseLoaded);
            }
        }
    }
}

