/*
 * Decompiled with CFR 0.152.
 */
package terrablender.worldgen.noise;

import net.minecraft.util.LinearCongruentialGenerator;
import terrablender.worldgen.noise.Area;
import terrablender.worldgen.noise.PixelTransformer;

public class AreaContext {
    private static final int MAX_CACHE = 1024;
    private final int maxCache;
    private final long seed;
    private long rval;

    public AreaContext(int maxCache, long worldSeed, long seedModifier) {
        this.seed = AreaContext.mixSeed(worldSeed, seedModifier);
        this.maxCache = maxCache;
    }

    public Area createResult(PixelTransformer transformer) {
        return new Area(transformer, this.maxCache);
    }

    public Area createResult(PixelTransformer p_76541_, Area p_76542_) {
        return new Area(p_76541_, Math.min(1024, p_76542_.getMaxCache() * 4));
    }

    public Area createResult(PixelTransformer transformer, Area p_76545_, Area p_76546_) {
        return new Area(transformer, Math.min(1024, Math.max(p_76545_.getMaxCache(), p_76546_.getMaxCache()) * 4));
    }

    public void initRandom(long x, long y) {
        long i = this.seed;
        i = LinearCongruentialGenerator.m_13972_((long)i, (long)x);
        i = LinearCongruentialGenerator.m_13972_((long)i, (long)y);
        i = LinearCongruentialGenerator.m_13972_((long)i, (long)x);
        this.rval = i = LinearCongruentialGenerator.m_13972_((long)i, (long)y);
    }

    public int nextRandom(int bound) {
        int i = Math.floorMod(this.rval >> 24, bound);
        this.rval = LinearCongruentialGenerator.m_13972_((long)this.rval, (long)this.seed);
        return i;
    }

    public int random(int a, int b) {
        return this.nextRandom(2) == 0 ? a : b;
    }

    public int random(int a, int b, int c, int d) {
        int i = this.nextRandom(4);
        if (i == 0) {
            return a;
        }
        if (i == 1) {
            return b;
        }
        return i == 2 ? c : d;
    }

    private static long mixSeed(long worldSeed, long seedModifier) {
        long i = LinearCongruentialGenerator.m_13972_((long)seedModifier, (long)seedModifier);
        i = LinearCongruentialGenerator.m_13972_((long)i, (long)seedModifier);
        i = LinearCongruentialGenerator.m_13972_((long)i, (long)seedModifier);
        long j = LinearCongruentialGenerator.m_13972_((long)worldSeed, (long)i);
        j = LinearCongruentialGenerator.m_13972_((long)j, (long)i);
        return LinearCongruentialGenerator.m_13972_((long)j, (long)i);
    }
}

