/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.client.model;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.client.model.WrappedItemModel;
import vectorwing.farmersdelight.common.registry.ModItems;

public class SkilletModel
implements BakedModel {
    private final ModelBakery bakery;
    private final BakedModel originalModel;
    private final BakedModel cookingModel;
    private final ItemOverrides itemOverrides = new ItemOverrides(){

        @Nonnull
        public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entityIn, int seed) {
            CompoundTag tag = stack.m_41784_();
            if (tag.m_128441_("Cooking")) {
                ItemStack ingredientStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Cooking"));
                return SkilletModel.this.getCookingModel(ingredientStack);
            }
            return SkilletModel.this.originalModel;
        }
    };
    private final HashMap<Item, CompositeBakedModel> cache = new HashMap();

    public SkilletModel(ModelBakery bakery, BakedModel originalModel, BakedModel cookingModel) {
        this.bakery = bakery;
        this.originalModel = (BakedModel)Preconditions.checkNotNull((Object)originalModel);
        this.cookingModel = (BakedModel)Preconditions.checkNotNull((Object)cookingModel);
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return this.itemOverrides;
    }

    @Nonnull
    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand) {
        return this.originalModel.m_213637_(state, side, rand);
    }

    @Nonnull
    public ItemTransforms m_7442_() {
        return this.originalModel.m_7442_();
    }

    public boolean m_7541_() {
        return this.originalModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.originalModel.m_7539_();
    }

    public boolean m_7547_() {
        return this.originalModel.m_7547_();
    }

    public boolean m_7521_() {
        return this.originalModel.m_7521_();
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.originalModel.m_6160_();
    }

    private CompositeBakedModel getCookingModel(ItemStack ingredientStack) {
        return this.cache.computeIfAbsent(ingredientStack.m_41720_(), p -> new CompositeBakedModel(this.bakery, ingredientStack, this.cookingModel));
    }

    private static class CompositeBakedModel
    extends WrappedItemModel<BakedModel> {
        private final List<BakedQuad> genQuads = new ArrayList<BakedQuad>();
        private final Map<Direction, List<BakedQuad>> faceQuads = new EnumMap<Direction, List<BakedQuad>>(Direction.class);

        /*
         * Unable to fully structure code
         */
        public CompositeBakedModel(ModelBakery bakery, ItemStack ingredientStack, BakedModel skillet) {
            super(skillet);
            ingredientLocation = ForgeRegistries.ITEMS.getKey((Object)ingredientStack.m_41720_());
            ingredientUnbaked = bakery.m_119341_((ResourceLocation)new ModelResourceLocation(ingredientLocation, "inventory"));
            transform = new SimpleModelState(new Transformation(new Vector3f(0.0f, -0.4f, 0.0f), Vector3f.f_122223_.m_122240_(270.0f), new Vector3f(0.625f, 0.625f, 0.625f), null));
            name = new ResourceLocation("farmersdelight", "skillet_with_" + ingredientLocation.toString().replace(':', '_'));
            if (!(ingredientUnbaked instanceof BlockModel)) ** GOTO lbl-1000
            bm = (Direction[])ingredientUnbaked;
            if (((BlockModel)ingredientUnbaked).m_111490_() == ModelBakery.f_119232_) {
                ingredientBaked = new ItemModelGenerator().m_111670_((Function<Material, TextureAtlasSprite>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, m_119204_(), (Lnet/minecraft/client/resources/model/Material;)Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;)(), (BlockModel)bm).m_111449_(bakery, (BlockModel)bm, (Function<Material, TextureAtlasSprite>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, m_119204_(), (Lnet/minecraft/client/resources/model/Material;)Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;)(), (ModelState)transform, name, false);
            } else lbl-1000:
            // 2 sources

            {
                ingredientBaked = ingredientUnbaked.m_7611_(bakery, (Function<Material, TextureAtlasSprite>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, m_119204_(), (Lnet/minecraft/client/resources/model/Material;)Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;)(), (ModelState)transform, name);
            }
            for (Direction e : Direction.values()) {
                this.faceQuads.put(e, new ArrayList<E>());
            }
            rand = RandomSource.m_216335_((long)0L);
            for (BakedModel pass : ingredientBaked.getRenderPasses(ingredientStack, false)) {
                this.genQuads.addAll(pass.getQuads(null, null, rand, ModelData.EMPTY, null));
                for (Direction e : Direction.values()) {
                    rand.m_188584_(0L);
                    this.faceQuads.get(e).addAll(pass.getQuads(null, e, rand, ModelData.EMPTY, null));
                }
            }
            for (BakedModel pass : skillet.getRenderPasses(((Item)ModItems.SKILLET.get()).m_7968_(), false)) {
                rand.m_188584_(0L);
                this.genQuads.addAll(pass.getQuads(null, null, rand, ModelData.EMPTY, null));
                for (Direction e : Direction.values()) {
                    rand.m_188584_(0L);
                    this.faceQuads.get(e).addAll(pass.getQuads(null, e, rand, ModelData.EMPTY, null));
                }
            }
        }

        @Override
        public boolean m_7521_() {
            return this.originalModel.m_7521_();
        }

        @Nonnull
        public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction face, @Nonnull RandomSource rand) {
            return face == null ? this.genQuads : this.faceQuads.get(face);
        }

        @Override
        public BakedModel applyTransform(@Nonnull ItemTransforms.TransformType cameraTransformType, PoseStack stack, boolean leftHand) {
            super.applyTransform(cameraTransformType, stack, leftHand);
            return this;
        }
    }
}

