/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block.entity;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.common.block.CuttingBoardBlock;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.common.mixin.accessor.RecipeManagerAccessor;
import vectorwing.farmersdelight.common.registry.ModAdvancements;
import vectorwing.farmersdelight.common.registry.ModBlockEntityTypes;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.tag.ForgeTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class CuttingBoardBlockEntity
extends SyncedBlockEntity {
    private final ItemStackHandler inventory = this.createHandler();
    private final LazyOptional<IItemHandler> inputHandler = LazyOptional.of(() -> this.inventory);
    private ResourceLocation lastRecipeID;
    private boolean isItemCarvingBoard = false;

    public CuttingBoardBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.CUTTING_BOARD.get(), pos, state);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.isItemCarvingBoard = compound.m_128471_("IsItemCarved");
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128379_("IsItemCarved", this.isItemCarvingBoard);
    }

    public boolean processStoredItemUsingTool(ItemStack toolStack, @Nullable Player player) {
        if (this.f_58857_ == null) {
            return false;
        }
        if (this.isItemCarvingBoard) {
            return false;
        }
        Optional<CuttingBoardRecipe> matchingRecipe = this.getMatchingRecipe(new RecipeWrapper((IItemHandlerModifiable)this.inventory), toolStack, player);
        matchingRecipe.ifPresent(recipe -> {
            List<ItemStack> results = recipe.rollResults(this.f_58857_.f_46441_, EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)toolStack));
            for (ItemStack resultStack : results) {
                Direction direction = ((Direction)this.m_58900_().m_61143_((Property)CuttingBoardBlock.FACING)).m_122428_();
                ItemUtils.spawnItemEntity(this.f_58857_, resultStack.m_41777_(), (double)this.f_58858_.m_123341_() + 0.5 + (double)direction.m_122429_() * 0.2, (double)this.f_58858_.m_123342_() + 0.2, (double)this.f_58858_.m_123343_() + 0.5 + (double)direction.m_122431_() * 0.2, (float)direction.m_122429_() * 0.2f, 0.0, (float)direction.m_122431_() * 0.2f);
            }
            if (player != null) {
                toolStack.m_41622_(1, (LivingEntity)player, user -> user.m_21166_(EquipmentSlot.MAINHAND));
            } else if (toolStack.m_220157_(1, this.f_58857_.f_46441_, null)) {
                toolStack.m_41764_(0);
            }
            this.playProcessingSound(recipe.getSoundEventID(), toolStack, this.getStoredItem());
            this.removeItem();
            if (player instanceof ServerPlayer) {
                ModAdvancements.CUTTING_BOARD.trigger((ServerPlayer)player);
            }
        });
        return matchingRecipe.isPresent();
    }

    private Optional<CuttingBoardRecipe> getMatchingRecipe(RecipeWrapper recipeWrapper, ItemStack toolStack, @Nullable Player player) {
        Recipe recipe;
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        if (this.lastRecipeID != null && (recipe = ((RecipeManagerAccessor)this.f_58857_.m_7465_()).getRecipeMap((RecipeType)ModRecipeTypes.CUTTING.get()).get(this.lastRecipeID)) instanceof CuttingBoardRecipe && recipe.m_5818_((Container)recipeWrapper, this.f_58857_) && ((CuttingBoardRecipe)recipe).getTool().test(toolStack)) {
            return Optional.of((CuttingBoardRecipe)recipe);
        }
        List recipeList = this.f_58857_.m_7465_().m_44056_((RecipeType)ModRecipeTypes.CUTTING.get(), (Container)recipeWrapper, this.f_58857_);
        if (recipeList.isEmpty()) {
            if (player != null) {
                player.m_5661_((Component)TextUtils.getTranslation("block.cutting_board.invalid_item", new Object[0]), true);
            }
            return Optional.empty();
        }
        Optional<CuttingBoardRecipe> recipe2 = recipeList.stream().filter(cuttingRecipe -> cuttingRecipe.getTool().test(toolStack)).findFirst();
        if (!recipe2.isPresent()) {
            if (player != null) {
                player.m_5661_((Component)TextUtils.getTranslation("block.cutting_board.invalid_tool", new Object[0]), true);
            }
            return Optional.empty();
        }
        this.lastRecipeID = recipe2.get().m_6423_();
        return recipe2;
    }

    public void playProcessingSound(String soundEventID, ItemStack tool, ItemStack boardItem) {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(soundEventID));
        if (sound != null) {
            this.playSound(sound, 1.0f, 1.0f);
        } else if (tool.m_204117_(Tags.Items.SHEARS)) {
            this.playSound(SoundEvents.f_12344_, 1.0f, 1.0f);
        } else if (tool.m_204117_(ForgeTags.TOOLS_KNIVES)) {
            this.playSound((SoundEvent)ModSounds.BLOCK_CUTTING_BOARD_KNIFE.get(), 0.8f, 1.0f);
        } else {
            Item item = boardItem.m_41720_();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                Block block = blockItem.m_40614_();
                SoundType soundType = block.m_49966_().m_60827_();
                this.playSound(soundType.m_56775_(), 1.0f, 0.8f);
            } else {
                this.playSound(SoundEvents.f_12630_, 1.0f, 0.8f);
            }
        }
    }

    public void playSound(SoundEvent sound, float volume, float pitch) {
        if (this.f_58857_ != null) {
            this.f_58857_.m_6263_(null, (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 0.5f), (double)((float)this.f_58858_.m_123343_() + 0.5f), sound, SoundSource.BLOCKS, volume, pitch);
        }
    }

    public boolean addItem(ItemStack itemStack) {
        if (this.isEmpty() && !itemStack.m_41619_()) {
            this.inventory.setStackInSlot(0, itemStack.m_41620_(1));
            this.isItemCarvingBoard = false;
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public boolean carveToolOnBoard(ItemStack tool) {
        if (this.addItem(tool)) {
            this.isItemCarvingBoard = true;
            return true;
        }
        return false;
    }

    public ItemStack removeItem() {
        if (!this.isEmpty()) {
            this.isItemCarvingBoard = false;
            ItemStack item = this.getStoredItem().m_41620_(1);
            this.inventoryChanged();
            return item;
        }
        return ItemStack.f_41583_;
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public ItemStack getStoredItem() {
        return this.inventory.getStackInSlot(0);
    }

    public boolean isEmpty() {
        return this.inventory.getStackInSlot(0).m_41619_();
    }

    public boolean isItemCarvingBoard() {
        return this.isItemCarvingBoard;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            return this.inputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this.inputHandler.invalidate();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(){

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                CuttingBoardBlockEntity.this.inventoryChanged();
            }
        };
    }
}

