/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.forge.network;

import fr.raksrinana.fallingtree.common.FallingTreeCommon;
import fr.raksrinana.fallingtree.common.network.ClientPacketHandler;
import fr.raksrinana.fallingtree.common.network.ConfigurationPacket;
import fr.raksrinana.fallingtree.common.network.ServerPacketHandler;
import fr.raksrinana.fallingtree.common.wrapper.IServerPlayer;
import fr.raksrinana.fallingtree.forge.common.wrapper.FriendlyByteBufWrapper;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;

public class ForgePacketHandler
implements ClientPacketHandler,
ServerPacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    private static final Collection<String> ALLOWED_VERSIONS = Set.of("1", NetworkRegistry.ABSENT, NetworkRegistry.ACCEPTVANILLA);
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("fallingtree", "main"), () -> "1", "1"::equals, v -> ALLOWED_VERSIONS.stream().anyMatch(v::equals));
    private static final int CONFIGURATION_MESSAGE_ID = 1;
    private final FallingTreeCommon<?> mod;

    @Override
    public void registerServer() {
        INSTANCE.registerMessage(1, ConfigurationPacket.class, (packet, buf) -> this.mod.getPacketUtils().encodeConfigurationPacket((ConfigurationPacket)packet, new FriendlyByteBufWrapper((FriendlyByteBuf)buf)), buf -> this.mod.getPacketUtils().decodeConfigurationPacket(new FriendlyByteBufWrapper((FriendlyByteBuf)buf)), this::handleConfigurationPacket);
    }

    @Override
    public void registerClient() {
    }

    public void handleConfigurationPacket(ConfigurationPacket configurationPacket, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.mod.getPacketUtils().onClientConfigurationPacket(configurationPacket)));
        context.setPacketHandled(true);
    }

    @Override
    public void onPlayerConnected(@NotNull IServerPlayer serverPlayer) {
        PacketDistributor.PacketTarget target = PacketDistributor.PLAYER.with(() -> (ServerPlayer)serverPlayer.getRaw());
        INSTANCE.send(target, (Object)this.mod.getPacketUtils().createConfigurationPacket());
    }

    public ForgePacketHandler(FallingTreeCommon<?> mod) {
        this.mod = mod;
    }
}

